*******************************************************************************
*                          680xx Grundprogramm bibo                           *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                           Menpunkt Bibliothek                              *
*******************************************************************************


suchbibo:                       * Einen oder mehrere Bibliothekseintrge suchen
 cmp #1,d0                      * d0 = 0  Von a0 an suchen
 beq.s suchbibc                 * d1 = 1  Von $400 an suchen
 lea $400,a0                    * In d2 und d3 steht der zu suchende Name
 tst d0                         * d1-d7 enthalten dann Daten Carry = 0
 beq.s suchbibc                 * Sonst Carry = 1
 clr.l (a1)                     * Endekennung setzen
 bsr suchbibf                   * d1 = 2 Alle Eintrge in einer Tabelle von a1
 bcs carset                     * an ablegen / Carry wenn kein Eintrag vorhanden
suchbiba:
 move.l a0,(a1)+                * Adresse Eintrag
 addq.l #4,a0                   * Kennung berspringen
 move.l (a0)+,(a1)+             * Name
 move.l (a0)+,(a1)+             * Name
 move.l (a0)+,d0                * Startadresse
 tst.b 4(a0)
 beq.s suchbibb
 add.l -12(a1),d0               * Relokativ, deshalb Adresse Eintrag addieren
suchbibb:
 move.l d0,(a1)+                * Startadresse ablegen
 move.l (a0)+,(a1)+             * Lnge
 move.w (a0)+,(a1)+             * Relokativ-Flag und CPU
 adda #10,a0                    * Reservierung berspringen
 bsr.s suchbibf                 * Nchsten Eintrag suchen
 bcc.s suchbiba                 * Schleife
 clr.l (a1)                     * Endekennung
bra carres                      * OK, mindestens ein Eintrag gefunden

wandled0:                       * Name (4 Buchstaben) in d0
 rol.l #8,d0                    * Alle Kleinbuchstaben werden in Grobuchstaben
 bsr bucheck                    * gewandelt
 rol.l #8,d0                    * Rest bleibt unverndert
 bsr bucheck
 rol.l #8,d0
 bsr bucheck
 rol.l #8,d0
bra bucheck

suchbibc:
 move.l d2,d0                   * Namen wandeln
 bsr.s wandled0
 exg.l d0,d3
 bsr.s wandled0
 move.l d0,d2                   * Name liegt jetzt in Grobuchstaben vor
suchbibd:
 bsr.s suchbibf                 * Eintrag suchen
 bcs carset                     * Nicht gefunden
 move.l 4(a0),d0
 bsr.s wandled0                 * In Grobuchstaben wandeln
 cmp.l d0,d3                    * Vergleichen
 bne.s suchbibe                 * Falsch
 move.l 8(a0),d0
 bsr.s wandled0                 * In Grobuchstaben wandeln
 cmp.l d0,d2                    * Vergleichen
 bne.s suchbibe                 * Falsch
 move.l a0,d1                   * Adresse Eintrag
 addq.l #4,a0
 movem.l (a0)+,d2-d5            * Daten
 move.b (a0)+,d6                * Relokativ-Flag
 move.b (a0)+,d7                * CPU
 tst.b d6
 beq carres                     * OK, wenn absolut
 add.l d1,d4                    * Relokativ
bra carres                      * OK
suchbibe:
 adda #32,a0                    * Reservierung berspringen
bra.s suchbibd                  * Weiter suchen

suchbibf:
 cmp.l #$55aa0180,(a0)          * Kennung suchen
 beq.s suchbibh
suchbibg:
 move.l a0,d0
 and #$fc00,d0                  * Auf Grenze bringen
 movea.l d0,a0
 adda #$400,a0                  * 1 Kbyte weiter
 cmpa.l #grenze,a0              * Ende erreicht ?
 bls.s suchbibf                 * Nein, dann weiter
bra carset
suchbibh:
 btst.b #0,15(a0)               * Sichheitstest
 bne.s suchbibg                 * Wenn ungerade, dann keine Startadresse
 tst.b 20(a0)
 beq.s suchbibi                 * OK, absolut
 cmp.b #1,20(a0)
 bne.s suchbibg                 * Fehler, da auch nicht relokativ
suchbibi:
 tst.b 21(a0)                   * Ohne Kennung
 beq carres
 cmp.b #cpu,21(a0)
 bne.s suchbibg                 * Falsche CPU
bra carres                      * OK

bibo:
 lea einbuf(a5),a6              * Pointer auf Bildanfangsadresse
 move.l #$400,(a6)              * Von $400 an suchen
bibo0:
 lea bibotxt0(pc),a0
 bsr headaclr                   * berschrift ausgeben
 lea bibotxt1(pc),a0
 moveq #$22,d0
 moveq #10,d1
 move #203,d2
 bsr textprint                  * Anzeige-Zeile
 lea bibotxt2(pc),a0
 moveq #$22,d0
 moveq #30,d1
 moveq #20,d2
 bsr textprint                  * Befehls-Zeile
 moveq #'A',d7                  * Kein Eintrag bisher
 moveq #16,d1                   * Anfang der Zeile
 move #188,d2                   * Auf oberste Zeile
 movea.l (a6),a4                * Anfangssuchadresse
 lea ausbuf(a5),a1              * Zieladresse Programmanfnge
bibo1:
 movea.l a4,a0
 bsr suchbibf                   * Eintrag suchen
 movea.l a0,a4
 bcs.s bibo3                    * Keinen gefunden
 moveq #0,d0                    * Nicht Verschiebbar
 lea bibotxt3(pc),a2            * NEIN
 tst.b 20(a4)                   * Null ?
 beq.s bibo2                    * Ja, dann OK
 addq.l #6,a2                   * JA
 move.l a4,d0                   * Verschiebeadresse
bibo2:
 addq.l #4,a4                   * Zeiger auf Name
 lea ausbuf+81(a5),a0           * Ziel fr eine Zeile
 move.b d7,(a0)+                * Auswahlbuchstabe
 move.l #'    ',(a0)+           * Leerraum
 move.l (a4)+,(a0)+             * Name
 move.l (a4)+,(a0)+             * 8 Buchstaben
 move.w #'  ',(a0)+             * Leerraum
 add.l (a4)+,d0                 * Startadresse + Basisadresse (Falls nicht Null)
 move.l d0,(a1)+                * Ablegen
 bsr print6x                    * Und ausgeben
 move #'  ',(a0)+
 move.l (a4)+,d0                * Lnge
 bsr print6x                    * Ausgeben
 move.l #'    ',(a0)+           * Leerraum
 move.l (a2),(a0)+              * JA oder NEIN
 clr.b (a0)                     * Ende
 moveq #$21,d0
 lea ausbuf+81(a5),a0
 bsr textprint                  * Ausgabe einer Zeile ohne Vorlschen
 adda #12,a4                    * Auf eventuellen nchsten Eintrag
 sub #13,d2                     * Eine Zeile tiefer
 addq #1,d7                     * Ein Eintrag mehr vorhanden
 cmp #'M',d7
 bne.s bibo1                    * Wenn noch Platz, dann nchste Zeile
bibo3:
 move.l a4,4(a6)                * Suchadresse nchste Seite
 lea ausbuf+81(a5),a0
 clr.b 1(a0)                    * Nur ein Zeichen
 moveq #$22,d0
 move #306,d1
 moveq #0,d2
 bsr textaus                    * Ausgabe (A- ) = Starten
bibo4:
 bsr ki                         * Zeichen holen und in Grobuchstaben wandeln
 cmp.b #$1b,d0
 beq carres                     * Ende
 cmp.b #'M',d0
 beq carres                     * Ende
 cmp.b #'+',d0                  * Eine Seite weiter ?
 bne.s bibo5                    * Nein
 cmp.l #grenze,4(a6)            * Wenn schon ganz hinten, dann nicht weiter
 bhi.s bibo4
 addq.l #4,a6                   * Pointer eine Seite weiter
bra bibo0                       * OK, neue Seite aufbauen
bibo5:
 cmp.b #'-',d0                  * Eine Seite zurck ?
 bne.s bibo6                    * Nein
 cmp.l #$400,(a6)               * Schon am Anfang ?
 beq.s bibo4                    * Ja, zurck zur Abfrage
 subq.l #4,a6                   * Pointer zurck
bra bibo0                       * Ausgabe
bibo6:
 cmp.b #'A',d0                  * Bereich 0-
 bmi.s bibo4                    * Zu klein
 cmp.b d7,d0                    * Zu gro ?
 bpl.s bibo4                    * Ja, dann zurck
 lsl #2,d0                      * Mal 4, da Langwort
 lea ausbuf-'A'*4(a5),a0        * Tabellenbeginn
 movea.l 0(a0,d0),a0            * Zieladresse
 bsr clrall                     * Bildschirm lschen
 move.b menflag(a5),-(a7)       * Men-Einstellungen retten
 bclr #7,menflag(a5)            * Ohne Hardcopy
 jsr (a0)                       * Programm aufrufen
 bsr seta5                      * Zur Sicherheit a5 auf alten Wert
 move.b (a7)+,menflag(a5)       * Zurck
* moveq #1,d0                    * nur 68020!!!
* movec.l d0,cacr                * Cache immer anschalten nur 68020!!!
bra finmenue                    * Ende

                                                                                                                                                                                                                                                                 119
 dc.l asserr                    * Befehl 120
 dc.l tnotimp                   * Befehl 121    Nur beim 68020
 dc.l tnotimp                   * Befehl 122    Nur beim 68020
 dc.l readaus                   * Befehl 123
 dc.l grund                     * Befehl 124
 dc.l hardcopy                  * Befehl 125
 dc.l grafik                    * Befehl 126
 dc.l gdpvers                   * Befehl 127
 dc.l seraus                    * Befehl 128
 dc.l serex                     * Befehl 129
 dc.l clut